/*:
 * @target MZ
 * @plugindesc Spielt einen Beep-Sound bei Dialogbuchstaben ab (TalkBlip.ogg aus dem SE-Ordner). ✿
 * @author Yui
 *
 * @param Frequency
 * @text Beep-Frequenz
 * @desc Bestimmt, nach wie vielen Buchstaben der Beep abgespielt wird (1 = jeder Buchstabe, 2 = jeder zweite, etc.)
 * @type number
 * @min 1
 * @default 1
 *
 */

(() => {
    const parameters = PluginManager.parameters("TalkBlipBeep");
    const frequency = Number(parameters["Frequency"] || 1);

    const _Window_Base_processCharacter = Window_Base.prototype.processCharacter;
    Window_Base.prototype.processCharacter = function(textState) {
        _Window_Base_processCharacter.call(this, textState);

        if (this instanceof Window_Message) {
            if (!this._beepCounter) this._beepCounter = 0;
            this._beepCounter++;

            if (this._beepCounter % frequency === 0) {
                AudioManager.playSe({
                    name: "TalkBlip", // Datei muss in /audio/se/ liegen
                    volume: 90,
                    pitch: 100,
                    pan: 0
                });
            }
        }
    };
})();
